const {
  getBrowserList,
  deleteBatchBrowser,
  request
} = require('./request');
//=========================================
//CONSOLE LOG COLOR
const colours = {
    reset: "\x1b[0m",
    bright: "\x1b[1m",
    dim: "\x1b[2m",
    underscore: "\x1b[4m",
    blink: "\x1b[5m",
    reverse: "\x1b[7m",
    hidden: "\x1b[8m",

    fg: {
        black: "\x1b[30m",
        red: "\x1b[31m",
        green: "\x1b[32m",
        yellow: "\x1b[33m",
        blue: "\x1b[34m",
        magenta: "\x1b[35m",
        cyan: "\x1b[36m",
        white: "\x1b[37m",
        crimson: "\x1b[38m" // Scarlet
    },
    bg: {
        black: "\x1b[40m",
        red: "\x1b[41m",
        green: "\x1b[42m",
        yellow: "\x1b[43m",
        blue: "\x1b[44m",
        magenta: "\x1b[45m",
        cyan: "\x1b[46m",
        white: "\x1b[47m",
        crimson: "\x1b[48m"
    }
};
//=========================================
function getCurrentFormattedTime() {
  const now = new Date();
  const options = {
    hour: '2-digit',
    minute: '2-digit',
    day: '2-digit',
    month: '2-digit',
    year: 'numeric'
  };
  return now.toLocaleDateString('en-US', options);
}

async function getAllBrowserIds(page, pageSize) {
  try {
    const browserListResponse = await getBrowserList({ page, pageSize });

    if (browserListResponse.success) {
      const browserIds = browserListResponse.data.list.map(browser => browser.id);
      return browserIds;
    } else {
      console.error('Error getting browser IDs:', browserListResponse.msg);
      return [];
    }
  } catch (error) {
    console.error('Error getting browser IDs:', error.message);
    return [];
  }
}

async function deleteAllBrowsers() {
  const pageSize = 10;
  let page = 1;
  let totalDeleted = 0;

  try {
    while (true) {
      const browserIds = await getAllBrowserIds(page, pageSize);

      if (browserIds.length === 0) {
        break; // Stop the loop if no more browsers can be deleted
      }

      const deleteResponse = await deleteBatchBrowser(browserIds);

      if (deleteResponse.success) {
        totalDeleted += browserIds.length;
      } else {
        console.error('Error deleting browsers:', deleteResponse.msg);
        break; // Stop the loop if an error occurs
      }

      if (browserIds.length < pageSize) {
        const deleteRemainingResponse = await deleteBatchBrowser(browserIds);

        if (deleteRemainingResponse.success) {
          totalDeleted += browserIds.length;
        } else {
          console.error('Error deleting remaining browsers:', deleteRemainingResponse.msg);
        }

        break; // Stop the loop after deleting remaining browsers
      }

      page++;
    }
	
    // console.log(`[${getCurrentFormattedTime()}] Deleted: ${totalDeleted} browsers >> Waiting every 5 minutes...`);
    console.log(
		colours.reset,
		colours.fg.black,
		colours.bg.white, `${getCurrentFormattedTime()}`,
		colours.reset,
		colours.fg.black,colours.bg.green, 'DELETE',
		colours.fg.black,colours.bg.yellow, `${totalDeleted} ID`,
		colours.reset
    );
  } catch (error) {
    console.error('Error deleting browsers:', error.message);
  }
}

// Jalankan fungsi deleteAllBrowsers setiap 5 menit
setInterval(() => {
  deleteAllBrowsers();
}, 5 * 1000); // Interval dalam milidetik (5 menit * 60 detik * 1000 milidetik)

// Jalankan sekali saat aplikasi dimulai
deleteAllBrowsers();
